/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.screen;

import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.inventory.CraftingInventoryImproved;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackInventory;
import com.tiviacz.travelersbackpack.inventory.screen.slot.BackpackSlot;
import com.tiviacz.travelersbackpack.inventory.screen.slot.FluidSlot;
import com.tiviacz.travelersbackpack.inventory.screen.slot.ToolSlot;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1731;
import net.minecraft.class_1734;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2596;
import net.minecraft.class_2653;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3917;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import org.jetbrains.annotations.Nullable;

public class TravelersBackpackBaseScreenHandler
extends class_1703 {
    public class_1661 playerInventory;
    public ITravelersBackpackInventory inventory;
    public CraftingInventoryImproved craftMatrix;
    public class_1731 craftResult = new class_1731();
    private final int CRAFTING_GRID_START = 1;
    private final int CRAFTING_GRID_END = 9;
    private final int BACKPACK_INV_START = 10;
    private final int BACKPACK_INV_END = 48;
    private final int TOOL_START = 49;
    private final int TOOL_END = 50;
    private final int BUCKET_LEFT_IN = 51;
    private final int BUCKET_LEFT_OUT = 52;
    private final int BUCKET_RIGHT_IN = 53;
    private final int BUCKET_RIGHT_OUT = 54;
    private final int PLAYER_INV_START = 55;
    private final int PLAYER_HOT_END = 90;

    protected TravelersBackpackBaseScreenHandler(@Nullable class_3917<?> type, int syncId, class_1661 playerInventory, ITravelersBackpackInventory inventory) {
        super(type, syncId);
        this.playerInventory = playerInventory;
        this.inventory = inventory;
        this.craftMatrix = new CraftingInventoryImproved(inventory, this);
        int currentItemIndex = playerInventory.field_7545;
        this.addCraftResult();
        this.addCraftMatrix();
        this.addBackpackInventory(inventory);
        this.addToolSlots(inventory);
        this.addFluidSlots(inventory);
        this.addPlayerInventoryAndHotbar(playerInventory, currentItemIndex);
        this.method_7609(inventory.getCraftingGridInventory());
    }

    public void addCraftMatrix() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.method_7621(new BackpackSlot((class_1263)this.craftMatrix, j + i * 3, 152 + j * 18, 61 + i * 18));
            }
        }
    }

    public void addCraftResult() {
        this.method_7621((class_1735)new class_1734(this.playerInventory.field_7546, (class_1715)this.craftMatrix, (class_1263)this.craftResult, 0, 226, 97));
    }

    public void addBackpackInventory(ITravelersBackpackInventory inventory) {
        int j;
        int i;
        int slot = 0;
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 8; ++j) {
                this.method_7621(new BackpackSlot(inventory.getInventory(), slot++, 62 + j * 18, 7 + i * 18));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 5; ++j) {
                this.method_7621(new BackpackSlot(inventory.getInventory(), slot++, 62 + j * 18, 61 + i * 18));
            }
        }
    }

    public void addPlayerInventoryAndHotbar(class_1661 playerInv, int currentItemIndex) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.method_7621(new class_1735((class_1263)playerInv, x + y * 9 + 9, 44 + x * 18, 125 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.method_7621(new class_1735((class_1263)playerInv, x, 44 + x * 18, 183));
        }
    }

    public void addFluidSlots(ITravelersBackpackInventory inventory) {
        this.method_7621(new FluidSlot(inventory, 41, 6, 7));
        this.method_7621(new FluidSlot(inventory, 42, 6, 37));
        this.method_7621(new FluidSlot(inventory, 43, 226, 7));
        this.method_7621(new FluidSlot(inventory, 44, 226, 37));
    }

    public void addToolSlots(ITravelersBackpackInventory inventory) {
        this.method_7621(new ToolSlot(this.playerInventory.field_7546, inventory, 39, 44, 79));
        this.method_7621(new ToolSlot(this.playerInventory.field_7546, inventory, 40, 44, 97));
    }

    protected static void slotChangedCraftingGrid(class_1703 handler, class_1937 world, class_1657 player, class_1715 craftMatrix, class_1731 craftResult) {
        if (!world.field_9236) {
            class_3955 craftingRecipe;
            class_3222 serverPlayerEntity = (class_3222)player;
            class_1799 itemStack = class_1799.field_8037;
            Optional optional = world.method_8503().method_3772().method_8132(class_3956.field_17545, (class_1263)craftMatrix, world);
            if (optional.isPresent() && craftResult.method_7665(world, serverPlayerEntity, (class_1860)(craftingRecipe = (class_3955)optional.get()))) {
                itemStack = craftingRecipe.method_8116((class_1263)craftMatrix);
            }
            craftResult.method_5447(0, itemStack);
            serverPlayerEntity.field_13987.method_14364((class_2596)new class_2653(handler.field_7763, handler.method_37421(), 0, itemStack));
        }
    }

    public void method_7609(class_1263 inventory) {
        TravelersBackpackBaseScreenHandler.slotChangedCraftingGrid(this, this.playerInventory.field_7546.field_6002, this.playerInventory.field_7546, this.craftMatrix, this.craftResult);
    }

    public boolean method_7613(class_1799 stack, class_1735 slot) {
        return slot.field_7871 != this.craftResult && super.method_7613(stack, slot);
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1735 slot = this.method_7611(index);
        class_1799 result = class_1799.field_8037;
        if (slot != null && slot.method_7681()) {
            class_1799 stack = slot.method_7677();
            result = stack.method_7972();
            if (index >= 0 && index <= 54) {
                if (index == 0) {
                    stack.method_7909().method_7843(stack, player.field_6002, player);
                    if (!this.method_7616(stack, 55, 91, true)) {
                        return class_1799.field_8037;
                    }
                    slot.method_7670(stack, result);
                    this.craftMatrix.method_5431();
                } else if (!this.method_7616(stack, 55, 91, true)) {
                    return class_1799.field_8037;
                }
            }
            if (index >= 55) {
                if (ToolSlot.isValid(stack) && !this.method_7616(stack, 49, 51, false) && !this.method_7616(stack, 10, 49, false) && !this.method_7616(stack, 1, 10, false)) {
                    return class_1799.field_8037;
                }
                if (!this.method_7616(stack, 10, 49, false) && !this.method_7616(stack, 1, 10, false)) {
                    return class_1799.field_8037;
                }
            }
            if (stack.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            if (stack.method_7947() == result.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, stack);
        }
        return result;
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    public void method_7595(class_1657 playerIn) {
        super.method_7595(playerIn);
        if (this.inventory.getScreenID() != 3) {
            this.inventory.method_5431();
        }
        this.playSound(playerIn, this.inventory);
        TravelersBackpackBaseScreenHandler.clearBucketSlots(playerIn, this.inventory);
    }

    public static void clearBucketSlots(class_1657 playerIn, ITravelersBackpackInventory inventoryIn) {
        if (inventoryIn.getScreenID() == 1 && playerIn.method_6047().method_7909() instanceof TravelersBackpackItem || inventoryIn.getScreenID() == 2 && ComponentUtils.getWearingBackpack(playerIn).method_7909() instanceof TravelersBackpackItem) {
            for (int i = 41; i <= 44; ++i) {
                TravelersBackpackBaseScreenHandler.clearBucketSlot(playerIn, inventoryIn, i);
            }
        }
    }

    public static void clearBucketSlot(class_1657 playerIn, ITravelersBackpackInventory inventoryIn, int index) {
        if (!inventoryIn.getInventory().method_5438(index).method_7960()) {
            if (!playerIn.method_5805() || playerIn instanceof class_3222 && ((class_3222)playerIn).method_14239()) {
                class_1799 stack = inventoryIn.getInventory().method_5438(index).method_7972();
                inventoryIn.getInventory().method_5447(index, class_1799.field_8037);
                playerIn.method_7328(stack, false);
            } else {
                class_1799 stack = inventoryIn.getInventory().method_5438(index);
                inventoryIn.getInventory().method_5447(index, class_1799.field_8037);
                playerIn.method_31548().method_7398(stack);
            }
        }
    }

    public void playSound(class_1657 playerIn, ITravelersBackpackInventory inventoryIn) {
        for (int i = 41; i <= 44; ++i) {
            if (inventoryIn.getInventory().method_5438(i).method_7960()) continue;
            playerIn.field_6002.method_8396(playerIn, playerIn.method_24515(), class_3417.field_15197, class_3419.field_15245, 1.0f, (1.0f + (playerIn.field_6002.field_9229.nextFloat() - playerIn.field_6002.field_9229.nextFloat()) * 0.2f) * 0.7f);
            break;
        }
    }
}

